CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name='est_prod_desconto_temp') THEN 
			CREATE TABLE public.est_prod_desconto_temp
			(
			  cd_ctr_orc 	numeric NOT NULL DEFAULT 0,
			  cd_ctr_vd  	numeric NOT NULL DEFAULT 0,
			  cd_emp 		numeric NOT NULL DEFAULT 0,
			  cd_filial 	numeric NOT NULL DEFAULT 0,
			  cd_prod 		numeric NOT NULL DEFAULT 0,
			  cd_it 		numeric NOT NULL DEFAULT 0,
			  qt_it 		numeric(10,4) DEFAULT 0,
			  vlr_item 		numeric(10,4) DEFAULT 0,
			  vlr_item_liq 	numeric(10,4) DEFAULT 0,
			  CONSTRAINT est_prod_desconto_temp_pkey 
				PRIMARY KEY (cd_ctr_orc, cd_ctr_vd, cd_emp, cd_filial, cd_it)
			)
			WITH ( OIDS=FALSE );
			ALTER TABLE public.est_prod_desconto_temp
			  OWNER TO postgres;
        RAISE NOTICE 'Operacao realizada com sucesso. -  est_prod_desconto_temp';
    ELSE 
		RAISE NOTICE 'Tabela est_prod_desconto_temp já EXISTE.'; 
    END IF; 
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();
